﻿//////////////////////////////////////////////
// CameraManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class RenderContext ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Camera.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <unordered_map>
#include <mutex>
#include <string>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT CameraManager final : public Manager<Camera>, public nkCommon::MaybeSingletonClass<CameraManager>
	{
		public :

			// Getters
			Camera* getActiveRenderCamera () const ;
			Camera* getActiveCullingCamera () const ;
			Camera* getActiveLodCamera () const ;
			Camera* getDefaultCamera () const ;

			// Setters
			void setActiveRenderCamera (Camera* cam) ;
			void setActiveCullingCamera (Camera* cam) ;
			void setActiveLodCamera (Camera* cam) ;
			void setDefaultCamera (Camera* cam) ;

			// Reset during rendering
			void resetRenderCameraToDefault () ;
			void resetCullingCameraToDefault () ;
			void resetLodCameraToDefault () ;

			// Context
			void prepareForContext (RenderContext* context) ;

		private :

			// Functions
			// Constructor
			CameraManager (bool isSingleton) noexcept ;
			CameraManager (System* system) noexcept ;

		private :
			
			// Attributes
			Camera* _activeRenderCamera ;
			Camera* _activeCullingCamera ;
			Camera* _activeLodCamera ;
			Camera* _defaultCamera ;

		private :

			friend class nkCommon::MaybeSingletonClass<CameraManager> ;
			friend class System ;
	} ;
}